<?php
Class Analysis extends Autopilot
{
	var $keys;
	var $gap_these;
	
	public function __Construct()
	{
		parent::db_connect();
	}
	
	public function analyze()
	{
		$this->load_finished();
		$this->sort_keys();
		$this->insert_keys();
	}
	
	public function load_finished()
	{
		$f=scandir('./global/compared');
		unset($f[0]);
		unset($f[1]);
		unset($f[2]);
		$valid=array_unique($f);
		return $this->keys=$valid;
	}
	
	public function load_job($key)
	{
		$name=explode("-",$key);
		$query="SELECT * FROM `jobs` where(`acc1`='{$name[0]}')AND(`acc2`='{$name[1]}');";
		$res=mysql_query($query);
		$r=mysql_fetch_array($res);
		return $r;
	}
	
	public function job_stats()
	{
		$jobs=mysql_query("SELECT COUNT(*) FROM `jobs` WHERE 1;");
		$jobs=mysql_fetch_array($jobs);
		$jobs=$jobs[0];
		$complete=mysql_query("SELECT COUNT(*) FROM `jobs` WHERE `status`='2';");
		$complete=mysql_fetch_array($complete);
		$complete=$complete[0];
		$inprogress=mysql_query("SELECT COUNT(*) FROM `jobs` WHERE `status`='1';");
		$inprogress=mysql_fetch_array($inprogress);
		$inprogress=$inprogress[0];
		$percent = number_format(($complete * 100) / $jobs);
		return array($percent,$jobs,$complete,$inprogress);
	}

	public function get_top_ss_score($key)
	{
		$vars=file_get_contents("./global/compared/$key/vars");
		$vars=unserialize($vars);
		$frames=$vars['frames'];
		$scores=array_keys($frames);
		//print_r($scores);
		return $scores[0];
	}
	
	public function sort_keys()
	{
		foreach($this->keys as $key)
		{
			$score=$this->get_top_ss_score($key);
			$sort[$score][]=$key;
		}
		ksort($sort);
		$this->keys=array_reverse($sort);
	}
		
	public function insert_keys()
	{
		foreach($this->keys as $score=>$array)
		{
			foreach($array as $key)
			{
				$job=$this->load_job($key);
				if($job)
				{
					$query="insert into `pilot`.`analysis` ( `tcid2`, `acc1`, `tcid1`, `acc2`, `fam2`, `topscore`, `fam1`, `id`) 
					values ( '{$job['tc2']}', '{$job['acc1']}', '{$job['tc1']}', '{$job['acc2']}', '{$job['family2']}', '$score', '{$job['family1']}', '0')";
					$check="SELECT * FROM `analysis` WHERE(`tcid2`='{$job['tc2']}')AND(`acc1`='{$job['acc1']}')AND
					(`tcid1`='{$job['tc1']}')AND(`acc2`='{$job['acc2']}')AND(`fam2`='{$job['family2']}')AND(`fam1`='{$job['family1']}');";
					$check=mysql_query($check);
					if(!mysql_num_rows($check))
					{
						mysql_query($query);
					}
				}
			}
		}
	}
	
	public function load_results($f1,$f2,$mintms=NULL)
	{
		if($mintms)
		{
			$q=mysql_query("SELECT * FROM `analysis` WHERE (`fam1`LIKE '$f1')AND(`fam2`LIKE '$f2')AND(`tms1`>=$mintms)AND(`tms2`>=$mintms) ORDER BY `topscore` DESC;");
		} else
		{
			$q=mysql_query("SELECT * FROM `analysis` WHERE (`fam1`LIKE '$f1')AND(`fam2`LIKE'$f2') ORDER BY `topscore` DESC;");
		}
		if(!mysql_num_rows($q))
		{
			return FALSE;
		}
		while($r=mysql_fetch_array($q))
		{
			$r['topscore']=round($r['topscore'],1);
			$r['gapscore']=round($r['gapscore'],1);
			$res[]=$r;
		}
		return $res;
	}
	
	public function run_gap($key,$needle=FALSE)
	{
		$vars=(file_exists("./global/compared/$key/vars.reasonable"))?file_get_contents("./global/compared/$key/vars.reasonable"):file_get_contents("./global/compared/$key/vars");
		$vars=unserialize($vars);
		$frames=$vars['frames'];
		$scores=array_keys($frames);
		$fullfastas=$vars['fullfastas'];
		chdir("./global/compared/$key/gap/");
		if(!$needle)
		{
			foreach($scores as $score)
			{
				if($score>=7)
				{
					$valids[]=$score;
				}
			}
		} else
		{
			$valids=$scores;
		}
		//$valids=array($scores[0],$scores[1],$scores[2],$scores[3],$scores[4],$scores[5],$scores[6]);
		$gres=fopen("../gap_scores","a+");
		$first=NULL;
		$showtop=TRUE;
		foreach($valids as $id=>$valid)
		{
			foreach($frames[$valid] as $frame)
			{
				$headers=Protocol2::find_headers($frame);
				$seq1=$fullfastas[md5($headers[0])];
				$seq1=preg_replace('/(\n+)|(\s+)/',NULL,$seq1[1]);
				$seq2=$fullfastas[md5($headers[1])];
				$seq2=preg_replace('/(\n+)|(\s+)/',NULL,$seq2[1]);
				$hash=md5($frame);
				if(file_exists("$hash.aln2"))
				{
					$showtop=FALSE;
					break;
				}
				$this->gap_these[]=$hash;
				if(!$needle)
				{
					$handle=fopen("$hash", "w+");
					fwrite($handle,$frame);
					echo ">> GAPING $hash \n";
					system("gapq $hash 5 > ./$hash.out");
					$gseq=Protocol2::readgap($hash);
					system("hmmgap $seq1 {$gseq[0]} $hash.aln1");
					system("hmmgap $seq2 {$gseq[1]} $hash.aln2");
					$res=file_get_contents("$hash.out");
					preg_match_all('/Average Deviation: \d+\.?\d*/',$res,$out,PREG_PATTERN_ORDER);
					$avg=str_replace('Average Deviation: ',NULL,$out[0][0]);
					$first=(is_null($first))?$avg:$first;
					fwrite($gres,"$avg\n");
				} else
				{
					echo "$key:$id";
					$targets=explode(">",$frame);
					unset($targets[0]);
					$score=$this->needle(">$targets[1]",">$targets[2]","$hash.out");
					$gseq=Protocol2::readneedle($hash);
		
					system("hmmgap $seq1 {$gseq[0]} $hash.aln1");
					system("hmmgap $seq2 {$gseq[1]} $hash.aln2");
					fwrite($gres,"$score (NW)\n");
			
					//echo $score;
				}
				
			}
		}
		chdir("../../../../");
		if($showtop)
		{
			return $first;
		} else
		{
			return FALSE;
		}
	}
	
	public function needle($a,$b,$out)
	{
		$handle=fopen("/tmp/a","w+");
		fwrite($handle,$a);
		fclose($handle);
		$handle=fopen("/tmp/b","w+");
		fwrite($handle,$b);
		fclose($handle);
		$cmd="needle -asequence '/tmp/a' -bsequence '/tmp/b' -gapopen 10 -gapextend 0.5 -outfile './$out'";
		system($cmd);
		system('clear');
		$res=file_get_contents($out);
		preg_match_all('/# Score: [0-9,\.]{1,5}/',$res,$score);
		$score=preg_replace("/[^0-9,\.]/",NULL,$score[0][0]);
		return $score;
	}
	
	public function gap_all($fam1,$fam2,$tms=NULL)
	{
		if($tms)
		{
			$q=mysql_query("SELECT * FROM `analysis` WHERE (`topscore` >=7)AND(`fam1`LIKE '$fam1')AND(`fam2` LIKE '$fam2')AND(`tms1`>=$tms)AND(`tms2`>=$tms);");
		} else
		{
			$q=mysql_query("SELECT * FROM `analysis` WHERE (`topscore` >=7)AND(`fam1`LIKE '$fam1')AND(`fam2` LIKE '$fam2');");
		}
		while($r=mysql_fetch_array($q))
		{
			$this->gap_id($r['id']);
		}
	}
	
	public function gap_id($id)
	{
		$q=mysql_query("SELECT * FROM `analysis` WHERE(`id`='$id');");
		$r=mysql_fetch_array($q);
		$key="{$r['acc1']}-{$r['acc2']}";
		echo "::$id::";
		$top=$this->run_gap($key);
		if($top)
		{
			mysql_query("update `pilot`.`analysis` set `gapscore`='$top' where `id`='{$r['id']}';");
		}
	}
	
	public function fix_top_gap($fam1,$fam2)
	{
		$q=mysql_query("SELECT * FROM `analysis` WHERE (`topscore` >=7)AND(`fam1`LIKE '$fam1')AND(`fam2` LIKE '$fam2');");
		while($r=mysql_fetch_array($q))
		{

			$key="{$r['acc1']}-{$r['acc2']}";
			chdir(GlobalD::REMOTEDIR.'compared/'.$key);
			$vars=file_exists('vars.reasonable')?file_get_contents('vars.reasonable'):file_get_contents('vars');
			$vars=unserialize($vars);
			foreach($vars['frames'] as $frames)
			{
				foreach($frames as $frame)
				{
					$hash=md5($frame);
					$res=@file_get_contents("gap/$hash.out");
					if(!$res){continue;}
					if(!eregi('needle',$res))
					{
						preg_match_all('/Average Deviation: \d+\.?\d*/',$res,$out,PREG_PATTERN_ORDER);
						$avg=str_replace('Average Deviation: ',NULL,$out[0][0]);
						$gaps[]=$avg;
					} else
					{
						$gaps[]=NULL;
					}
				}
			}
			$file=fopen("gap_scores","w+");
			fwrite($file,implode("\n",$gaps));
			mysql_query("update `pilot`.`analysis` set `gapscore`='{$gaps[0]}' where `id`='{$r['id']}';");
			$gaps=array();
		}
	}
	
	public function examine_existing_gaps($fam1,$fam2)
	{
		$q=mysql_query("SELECT * FROM `analysis` WHERE (`fam1` LIKE '$fam1')AND(`fam2` LIKE '$fam2');");
		while($r=mysql_fetch_array($q))
		{
			$key="{$r['acc1']}-{$r['acc2']}";
			$vars=file_get_contents("./global/compared/$key/vars");
			$vars=unserialize($vars);
			$frames=$vars['frames'];
			$scores=array_keys($frames);
			$top=$scores[0];
			$sig=md5($frames[$top][0]);
			$res=file_get_contents("./global/compared/$key/gap/$sig.out");
			preg_match_all('/Average Deviation: \d+\.?\d*/',$res,$out,PREG_PATTERN_ORDER);
			$avg=str_replace('Average Deviation: ',NULL,$out[0][0]);
			echo "$avg : $sig : $key \n";
			mysql_query("update `pilot`.`analysis` set `gapscore`='$avg' where `id`='{$r['id']}';");
		}
	}
	
	public function trim_key($key)
	{
		$vars=file_get_contents("./global/compared/$key/vars");
		$vars=unserialize($vars);
		
		array_splice($vars['sssresults'],200);
		array_splice($vars['frames'],200);
		//array_splice($vars['fullfastas'],200);
		$vars=serialize($vars);
		$handle=fopen("./global/compared/$key/vars.reasonable","w+");
		fwrite($handle,$vars);
		return TRUE;
	}
	
	public function trim_results()
	{
		$q=mysql_query("SELECT * FROM `analysis` WHERE 1;");
		while($r=mysql_fetch_array($q))
		{
			$key="{$r['acc1']}-{$r['acc2']}";
			
			if(!file_exists("./global/compared/$key/vars.reasonable"))
			{
				$this->trim_key($key);
			}
			
		}
	}
	
	function get_tms($sequence)
	{
		ob_start();
		$uid = "tms_count.seq";
	//	$sequence=$argv[2];
		$fpseqfile1 = fopen("/tmp/$uid", "w+");
		fwrite($fpseqfile1, ">MY_SEQ\n$sequence");
		fclose($fpseqfile1);
		$command = "hmmtop -if=/tmp/$uid";
		$can = system($command);
		ob_end_clean();
		$chunks = preg_split("/\s+/", $can, 5);
		$chunks = preg_split("/\s+/", $chunks[4]);
		unlink("/tmp/$uid");
		return $chunks[0];
	}
	
	public function fill_tms()
	{
		require('upe.function.php');
		$query=mysql_query("SELECT * FROM `analysis` WHERE(`tms1` IS NULL)AND(`tms2` IS NULL);");
		while($r=mysql_fetch_array($query))
		{
			$id=$r['id'];
			$acc1=$r['acc1'];
			$acc2=$r['acc2'];
			$seq1=upe($acc1);
			$seq1=$seq1[12];
			$seq2=upe($acc2);
			$seq2=$seq2[12];
			$tms1=$this->get_tms($seq1);
			$tms2=$this->get_tms($seq2);
			$update="update `pilot`.`analysis` set `tms2`='$tms2', `tms1`='$tms1' where `id`='$id';";
			mysql_query($update);
		}
	}
	
	public function generate_clustal_input($id,$rows)
	{
		$query=mysql_query("SELECT * FROM `analysis` WHERE(`id`='$id');");
		$res=mysql_fetch_array($query);
		$key="{$res['acc1']}-{$res['acc2']}";
		chdir("./global/compared/$key");
		if(file_exists("vars.reasonable"))
		{
			$vars=file_get_contents("vars.reasonable");
		} else
		{
			$vars=file_get_contents("vars");
		}
		
		$vars=unserialize($vars);
		$i=0;
		$rows=explode(",",$rows);
		foreach($vars['frames'] as $frames)
		{
			foreach($frames as $frame)
			{
				/*
				$hash=md5($frame);
				if(!file_exists("gap/$hash.aln2")) { continue; }
				$aln1=preg_replace('/\./',NULL,file_get_contents("gap/$hash.aln1"));
				$aln2=preg_replace('/\./',NULL,file_get_contents("gap/$hash.aln2"));
				$tms='/<b>([A-Z,\.])+<\/b>/is';
				preg_match_all($tms,$aln1,$a1);
				preg_match_all($tms,$aln2,$a2);
				$a1=count($a1[0]);
				$a2=count($a2[0]);
				if(($a1>=$min)&&($a2>=$min))
				{
					$headers=Protocol2::find_headers($frame);
					$f1[]=trim(implode("\n",$vars['fullfastas'][md5($headers[0])]));
					$f2[]=trim(implode("\n",$vars['fullfastas'][md5($headers[1])]));
				}
				*/
				if((in_array($i,$rows))||($i==$rows))
				{
					$headers=Protocol2::find_headers($frame);
					$f1[]=trim(implode("\n",$vars['fullfastas'][md5($headers[0])]));
					$f2[]=trim(implode("\n",$vars['fullfastas'][md5($headers[1])]));
				}
				$i++;
			}
		}
		$f1=array_unique($f1);
		$f2=array_unique($f2);
		@mkdir('clustal');
		chdir('clustal');
		$handle=fopen("family1.faa","w+");
		fwrite($handle,implode("\n",$f1));
		fclose($handle);
		$handle=fopen("family2.faa","w+");
		fwrite($handle,implode("\n",$f2));
		fclose($handle);
		system('open ./');
	}
}



?>