<?
Class Protocol2 extends GlobalD
{
	var $sss_out='sss_results.txt';
	var $fasta_file1='fasta1.faa';
	var $fasta_file2='fasta2.faa';
	var $raw_fastas;
	var $sss_results;
	var $fastas;
	var $reading_frames;
	var $target_fastas;
	var $gap_these;
	var $status=TRUE;
	
	public function __Construct($dir1,$dir2)
	{
		chdir(parent::LOCALDIR);
		$this->fasta_file1=getcwd()."/accs/$dir1/sequences_fasta.xml.faa";
		$this->fasta_file2=getcwd()."/accs/$dir2/sequences_fasta.xml.faa";
		$this->load_data();
		$output="$dir1-$dir2";
		@mkdir('compared');
		chdir('compared');
		@mkdir($output);
		chdir($output);
		$this->sss();
		$this->load_sss_results();
		$this->load_reading_frames();
		$this->sort_frames();
		$this->sort_sss_results();
		$this->parse_target_fastas();
		$this->select_gaps();
		@mkdir("gap");
		chdir("gap");
		$this->gap_selected(5);
		chdir('../');
		$this->write_variables('vars');
		system("report.php > report.html");
		$this->write_status();
	}
	
	public function load_data()
	{
		echo "\n>> Loading Data...";
		$fastas=trim(file_get_contents($this->fasta_file1)."\n".file_get_contents($this->fasta_file2));
		$this->raw_fastas=$fastas;
		// parse fasta
		$fastas=explode(">",$fastas);
		foreach($fastas as $fasta)
		{
			$line=explode("\n",$fasta);
			$header=$line[0];
			unset($line[0]);
			$seq=implode("\n",$line);
			$seq=preg_replace("/\n/",'',$seq);
			$id=explode(' ',$header);
			$id=$id[0];
			$this->fastas[$id][]=array(">$header",$seq);
		}
		unset($this->fastas[NULL]);
		echo "Done!";
		return TRUE;
	}
	
	function load_sss_results()
	{
		$this->sss_results=trim(file_get_contents($this->sss_out));
		$results=explode("\n",$this->sss_results);
		if(strlen($this->sss_results)<5)
		{
			$this->status=FALSE;
			$this->write_status();
			die("\n>> SSS Found 0 Results\n");
		}
		foreach($results as $result)
		{
			$result=explode("\t",trim($result));
			$res[]=$result;
		}
		$this->sss_results=$res;
	}
	
	function sort_sss_results()
	{
		//print_r($this->sss_results);
		foreach($this->sss_results as $result)
		{
			$key=$result[5];
			$sorted[$key][]=$result;
		}
		
		ksort($sorted);
		$this->sss_results=array_reverse($sorted);
	}
	
	public function select_from_dir($dir)
	{
		$files=scandir($dir);
		foreach($files as $file)
		{
			if(preg_match('/\.faa/i',$file))
			{
				$valid[]=$file;
			}
		}
		if($num=count($valid))
		{
			echo "\nFound $num Usable Files:\n";
			foreach($valid as $key=>$file)
			{
				echo "[$key] :: $file\n";
			}
			return $valid;
		} else
		{
			die("\n[X] No .FAA files found\n\n");
		}
	}
	
	function sss()
	{
		$cmd="sss.pl -i1 {$this->fasta_file1} -i2 {$this->fasta_file2} -o {$this->sss_out}\n\n";
		system($cmd);
	}
	
	public function getInput($msg)
	{
		fwrite(STDOUT, "$msg: ");
		$varin = trim(fgets(STDIN));
		return $varin;
	}
	
	private function get_frame($string)
	{
		$pattern='/[A-Z]{1,7}-[A-Z]{1,7}/';
		preg_match_all($pattern,$string,$out,PREG_PATTERN_ORDER);
		$res=$out[0][0];
		$res=explode('-',$res);
		preg_match_all('/[0-9]{1,10}/',$string,$len,PREG_PATTERN_ORDER);
		$length=$len[0][1]-$len[0][0]+1;
		$res[]=$length;
		return $res;
	}
	
	private function load_frame($frames,$seq)
	{
		$start=$frames[0];
		$end=$frames[1];
		$len=$frames[2];
		foreach($seq as $window)
		{
			if((preg_match("/$start/",$window[1]))&&(preg_match("/$end/",$window[1])))
			{
				$pattern="/$start.[A-Z]{1,".$len."}$end/s";
				//echo $pattern;
				preg_match_all($pattern,$window[1],$out,PREG_PATTERN_ORDER);
				//print_r($out); exit;
				$fasta="{$window[0]}\n{$out[0][0]}";
				return $fasta;
			}
		}
		return FALSE;
	}
	
	
	public function load_reading_frames()
	{
		//print_r($this->sss_results); exit;
		foreach($this->sss_results as $result)
		{
			// First Seq
			$id='/^[A-Z0-9]{1,7}/i';
			preg_match_all($id,$result[0],$id1,PREG_PATTERN_ORDER);
			preg_match_all($id,$result[2],$id2,PREG_PATTERN_ORDER);
			$first=$this->fastas[$id1[0][0]];
			//$fullfasta[md5($first[0][0])]=$first[0];
			$frame=$this->get_frame($result[1]);
			$first=$this->load_frame($frame,$first);
			// Second seq
			$sec=$this->fastas[$id2[0][0]];
			//$fullfasta[md5($sec[0][0])]=$sec[0];
			$frame=$this->get_frame($result[3]);
			$sec=$this->load_frame($frame,$sec);
			$fastas[]="$first\n$sec";
		}
		//$this->target_fastas=$fullfasta;
		return $this->reading_frames=$fastas;
	}
	
	public function sort_frames()
	{
		foreach($this->sss_results as $i=>$res)
		{
			$key=$res[5];
			$sorted[$key][]=$this->reading_frames[$i];
		}
		ksort($sorted);
		$sorted=array_reverse($sorted);
		return $this->reading_frames=$sorted;
	}
	
	private function write_variables($file)
	{
		$array=array("sssresults"=>$this->sss_results,"frames"=>$this->reading_frames,"fullfastas"=>$this->target_fastas);
		$array=$this->trim_key($array);
		$array=serialize($array);
		$handle=fopen($file,"w+");
		fwrite($handle,$array);
		return TRUE;
	}
	
	public function trim_key($vars)
	{
		array_splice($vars['sssresults'],200);
		array_splice($vars['frames'],200);
		//array_splice($vars['fullfastas'],200);
		return $vars;
		return TRUE;
	}
	
	public function select_gaps()
	{
		$i=1;
		//echo "\nHere are your SSS Results:\n";
		foreach($this->sss_results as $result)
		{
			foreach($result as $res)
			{
				$ores=$res;
				$res="[$i]\t".implode("\t",$res);
				if($ores[5]>=8)
				{
					echo "TOP: $i";
					$top[]=$i;
				}
				$i++;
				//echo "$res\n";
			}
		}
		return $this->gap_these=$top;
	}
	
	public function gap_selected($int)
	{
		$i=1;
		$gres=fopen("../gap_scores","w+");
		foreach($this->reading_frames as $frames)
		{
			foreach($frames as $window)
			{
				if(in_array($i,$this->gap_these))
				{
					$headers=$this->find_headers($window);
					$seq1=$this->target_fastas[md5($headers[0])];
					$seq1=preg_replace('/(\n+)|(\s+)/',NULL,$seq1[1]);
					$seq2=$this->target_fastas[md5($headers[1])];
					$seq2=preg_replace('/(\n+)|(\s+)/',NULL,$seq2[1]);
					$hash=md5($window);
					$handle=fopen($hash,"w+");
					fwrite($handle,$window);
					echo "% Running Gap(X5) on # $i\n";
					system("gstat -i $hash -o ./$hash.out");
					$gseq=$this->readneedle($hash);
					system("hmmgap $seq1 {$gseq[0]} $hash.aln1");
					system("hmmgap $seq2 {$gseq[1]} $hash.aln2");
					$res=file_get_contents("$hash.out");
					preg_match_all('/Average Deviation: \d+\.?\d*/',$res,$out,PREG_PATTERN_ORDER);
					preg_match_all('/(Z-Score: \d+\.?\d*)|(Average Deviation: \d+\.?\d*)/',$res,$out,PREG_PATTERN_ORDER);
					$avg=preg_replace('/(Z-Score: )|(Average Deviation: )/',NULL,$out[0][0]);
					fwrite($gres,"$avg\n");
				}
				$i++;
			}
		}
		return TRUE;
	}
	
	public function readgap($hash)
	{
		$file=file_get_contents("$hash.out");
		$res=explode('#################### Gap Result ####################',$file);
		$gap=$res[1];
		$pattern="/[0-9]{1,3} [A-Z,\.]{1,50} [0-9]{1,3}/";
		preg_match_all($pattern,$gap,$out,PREG_PATTERN_ORDER);

		foreach($out[0] as $gap)
		{
			$seq=preg_replace('/[^A-Z,\.]/',NULL,$gap);
			$patterns[]=$seq;
		}
		foreach($patterns as $key=>$seq)
		{
			if($key&1)
			{
				$second[]=$seq;
			} else
			{
				$first[]=$seq;
			}
		}
		$second=implode('',$second);
		$first=implode('',$first);
		return array($first,$second);
	}
	
	public function readneedle($hash)
	{
		$needle=file_get_contents("$hash.out");
		$pattern="/[0-9]{1,3}(\s)+[A-Z,\.]{1,50}(\s)+[0-9]{1,3}/";
		$needle=preg_replace('/-/','.',$needle);
		preg_match_all($pattern,$needle,$out,PREG_PATTERN_ORDER);
		foreach($out[0] as $gap)
		{
			$seq=preg_replace('/[^A-Z,\.]/',NULL,$gap);
			$patterns[]=$seq;
		}
		foreach($patterns as $key=>$seq)
		{
			if($key&1)
			{
				$second[]=$seq;
			} else
			{
				$first[]=$seq;
			}
		}
		$second=implode('',$second);
		$first=implode('',$first);
		return array($first,$second);
	}
	
	public function parse_target_fastas()
	{
		$fastas=explode(">",$this->raw_fastas);
		foreach($fastas as $fasta)
		{
			$fasta=">$fasta";
			$head=$this->find_headers($fasta);
			$head=$head[0];
			$seq=explode("\n",$fasta);
			unset($seq[0]);
			$seq=implode("\n",$seq);
			$key=md5($head);
			$omg[$key]=array($head,$seq);
		}
		return $this->target_fastas=$omg;
	}
	
	function find_headers($string)
	{
		$string=explode(">",$string);
		unset($string[0]);
		foreach($string as $s)
		{
			$s=explode("\n",$s);
			$headers[]=">".$s[0];
		}
		return $headers;
	}
	
	public function write_status()
	{
		$handle=fopen("status","w+");
		fwrite($handle,$this->status);
		return TRUE;
	}
	
}
?>